/*
 * Decompiled with CFR 0.152.
 */
package org.redlance.dima_dencep.mods.online_emotes.netty;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.zigythebird.playeranimcore.PlayerAnimLib;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.mc.McUtils;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.redlance.dima_dencep.mods.online_emotes.OnlineEmotes;
import org.redlance.dima_dencep.mods.online_emotes.OnlineEmotesConfig;
import org.redlance.dima_dencep.mods.online_emotes.client.FancyToast;
import org.redlance.dima_dencep.mods.online_emotes.network.OnlineNetworkInstance;

@ChannelHandler.Sharable
public class WebsocketHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private static final class_2561 DISCONNECTED = class_2561.method_43471((String)"online_emotes.messages.disconnected");
    private static final class_2561 CONNECTED = class_2561.method_43471((String)"online_emotes.messages.connected");
    private final OnlineNetworkInstance proxy;

    public WebsocketHandler(OnlineNetworkInstance proxy) {
        this.proxy = proxy;
    }

    public void channelInactive(@NotNull ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        if (OnlineEmotesConfig.debug()) {
            FancyToast.sendMessage(DISCONNECTED);
        }
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        if (OnlineEmotesConfig.debug()) {
            FancyToast.sendMessage(CONNECTED);
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame msg) {
        WebSocketFrame webSocketFrame = msg;
        Objects.requireNonNull(webSocketFrame);
        WebSocketFrame webSocketFrame2 = webSocketFrame;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BinaryWebSocketFrame.class, TextWebSocketFrame.class, PingWebSocketFrame.class, CloseWebSocketFrame.class}, (Object)webSocketFrame2, n)) {
            case 0: {
                BinaryWebSocketFrame frame = (BinaryWebSocketFrame)webSocketFrame2;
                this.proxy.receiveMessage(new EmotePacket(frame.content()));
                break;
            }
            case 1: {
                TextWebSocketFrame frame = (TextWebSocketFrame)webSocketFrame2;
                JsonElement element = (JsonElement)PlayerAnimLib.GSON.fromJson(frame.text(), JsonElement.class);
                if (!element.isJsonObject()) {
                    FancyToast.sendMessage(McUtils.fromJson((Object)element, (class_7225.class_7874)class_5455.field_40585));
                    break;
                }
                JsonObject object = element.getAsJsonObject();
                if (!object.has("message")) break;
                FancyToast.sendMessage(McUtils.fromJson((Object)object.get("message"), (class_7225.class_7874)class_5455.field_40585));
                break;
            }
            case 2: {
                PingWebSocketFrame frame = (PingWebSocketFrame)webSocketFrame2;
                frame.content().retain();
                ctx.channel().writeAndFlush((Object)new PongWebSocketFrame(frame.content()), ctx.channel().voidPromise());
                break;
            }
            case 3: {
                CloseWebSocketFrame ignored = (CloseWebSocketFrame)webSocketFrame2;
                ctx.channel().close();
                break;
            }
            default: {
                OnlineEmotes.LOGGER.error("Unsupported frame type: {}!", (Object)msg.getClass().getName());
            }
        }
    }
}

