/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.network;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.network.IClientPayloadData;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_634;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public interface IPluginClientPlayHandler<T extends class_8710>
extends ClientPlayNetworking.PlayPayloadHandler<T> {
    public static final int FROM_SERVER = 1;
    public static final int TO_SERVER = 2;
    public static final int BOTH_SERVER = 3;
    public static final int TO_CLIENT = 4;
    public static final int FROM_CLIENT = 5;
    public static final int BOTH_CLIENT = 6;

    public class_2960 getPayloadChannel();

    public boolean isPlayRegistered(class_2960 var1);

    public void setPlayRegistered(class_2960 var1);

    public void reset(class_2960 var1);

    default public void registerPlayPayload(@Nonnull // Could not load outer class - annotation placement on inner may be incorrect
    class_8710.class_9154<@NotNull T> id, @Nonnull class_9139<? super class_9129, @NotNull T> codec, int direction) {
        if (!this.isPlayRegistered(this.getPayloadChannel())) {
            try {
                switch (direction) {
                    case 2: 
                    case 5: {
                        PayloadTypeRegistry.playC2S().register(id, codec);
                        break;
                    }
                    case 1: 
                    case 4: {
                        PayloadTypeRegistry.playS2C().register(id, codec);
                        break;
                    }
                    default: {
                        PayloadTypeRegistry.playC2S().register(id, codec);
                        PayloadTypeRegistry.playS2C().register(id, codec);
                        break;
                    }
                }
            }
            catch (IllegalArgumentException e) {
                MaLiLib.LOGGER.error("registerPlayPayload: channel ID [{}] is is already registered", (Object)this.getPayloadChannel());
            }
            this.setPlayRegistered(this.getPayloadChannel());
            return;
        }
        MaLiLib.LOGGER.error("registerPlayPayload: channel ID [{}] is invalid, or it is already registered", (Object)this.getPayloadChannel());
    }

    default public boolean registerPlayReceiver(@Nonnull // Could not load outer class - annotation placement on inner may be incorrect
    class_8710.class_9154<@NotNull T> id, @Nullable // Could not load outer class - annotation placement on inner may be incorrect
    ClientPlayNetworking.PlayPayloadHandler<@NotNull T> receiver) {
        if (this.isPlayRegistered(this.getPayloadChannel())) {
            try {
                return ClientPlayNetworking.registerGlobalReceiver(id, (ClientPlayNetworking.PlayPayloadHandler)Objects.requireNonNullElse(receiver, this::receivePlayPayload));
            }
            catch (IllegalArgumentException e) {
                MaLiLib.LOGGER.error("registerPlayReceiver: Channel ID [{}] payload has not been registered", (Object)this.getPayloadChannel());
                return false;
            }
        }
        MaLiLib.LOGGER.error("registerPlayReceiver: Channel ID [{}] is invalid, or not registered", (Object)this.getPayloadChannel());
        return false;
    }

    default public void unregisterPlayReceiver() {
        ClientPlayNetworking.unregisterGlobalReceiver((class_2960)this.getPayloadChannel());
    }

    public void receivePlayPayload(T var1, ClientPlayNetworking.Context var2);

    default public void receivePlayPayload(T payload, class_634 handler, CallbackInfo ci) {
    }

    default public void decodeNbtCompound(class_2960 channel, class_2487 data) {
    }

    default public <D> void decodeObject(class_2960 channel, D data1) {
    }

    default public <P extends IClientPayloadData> void decodeClientData(class_2960 channel, P data) {
    }

    default public void encodeNbtCompound(class_2487 data) {
    }

    default public <D> void encodeObject(D data1) {
    }

    default public <P extends IClientPayloadData> void encodeClientData(P data) {
    }

    public void encodeWithSplitter(class_2540 var1, class_634 var2);

    default public boolean sendPlayPayload(@Nonnull T payload) {
        if (payload.method_56479().comp_2242().equals((Object)this.getPayloadChannel()) && this.isPlayRegistered(this.getPayloadChannel())) {
            if (ClientPlayNetworking.canSend((class_8710.class_9154)payload.method_56479())) {
                ClientPlayNetworking.send(payload);
                return true;
            }
        } else {
            MaLiLib.LOGGER.warn("sendPlayPayload: [Fabric-API] error sending payload for channel: {}, check if channel is registered", (Object)payload.method_56479().comp_2242().toString());
        }
        return false;
    }

    default public boolean sendPlayPayload(@Nonnull class_634 handler, @Nonnull T payload) {
        if (payload.method_56479().comp_2242().equals((Object)this.getPayloadChannel()) && this.isPlayRegistered(this.getPayloadChannel())) {
            class_2817 packet = new class_2817(payload);
            if (handler.method_52413((class_2596)packet)) {
                handler.method_52787((class_2596)packet);
                return true;
            }
        } else {
            MaLiLib.LOGGER.warn("sendPlayPayload: [NetworkHandler] error sending payload for channel: {}, check if channel is registered", (Object)payload.method_56479().comp_2242().toString());
        }
        return false;
    }
}

