/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.screenop.keyboard;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.screenop.keyboard.InputTarget;
import dev.isxander.controlify.screenop.keyboard.KeyboardLayoutWithId;
import dev.isxander.controlify.screenop.keyboard.KeyboardWidget;
import dev.isxander.controlify.utils.render.CGuiPose;
import java.util.function.Supplier;
import net.minecraft.class_11909;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_8027;
import net.minecraft.class_8030;

public class KeyboardOverlayScreen
extends class_437 {
    private final class_437 backgroundScreen;
    private final KeyboardLayoutWithId initialKeyboardLayout;
    private final InputTarget inputTarget;
    private final KeyboardPositioner keyboardPositioner;
    private KeyboardWidget keyboardWidget;

    public KeyboardOverlayScreen(class_437 backgroundScreen, KeyboardLayoutWithId initialKeyboardLayout, InputTarget inputTarget, KeyboardPositioner keyboardPositioner) {
        super(backgroundScreen.method_25440());
        this.backgroundScreen = backgroundScreen;
        this.initialKeyboardLayout = initialKeyboardLayout;
        this.inputTarget = new WrappedInputTarget(inputTarget);
        this.keyboardPositioner = keyboardPositioner;
    }

    protected void method_25426() {
        KeyboardLayoutWithId layout = this.keyboardWidget != null ? Controlify.instance().keyboardLayoutManager().getLayout(this.keyboardWidget.getCurrentLayoutId()) : this.initialKeyboardLayout;
        class_8030 keyboardRect = this.keyboardPositioner.positionKeyboard(this.field_22789, this.field_22790);
        this.keyboardWidget = (KeyboardWidget)this.method_37063((class_364)new KeyboardWidget(keyboardRect.method_49620(), keyboardRect.method_49618(), keyboardRect.comp_1196(), keyboardRect.comp_1197(), layout, this.inputTarget));
    }

    protected void method_48640() {
        super.method_48640();
        this.backgroundScreen.method_25423(this.field_22789, this.field_22790);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        CGuiPose pose = CGuiPose.ofPush(guiGraphics);
        this.backgroundScreen.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        pose.nextLayer(1000.0f);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.backgroundScreen.method_25420(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (super.method_25401(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        return this.backgroundScreen.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean method_25402(class_11909 mouseButtonEvent, boolean doubleClick) {
        if (super.method_25402(mouseButtonEvent, doubleClick)) {
            return true;
        }
        if (this.backgroundScreen.method_25402(mouseButtonEvent, doubleClick)) {
            this.method_25419();
            return true;
        }
        return false;
    }

    public void method_25393() {
        this.backgroundScreen.method_25393();
        super.method_25393();
    }

    public void method_25419() {
        this.field_22787.field_1755 = this.backgroundScreen;
        Controlify.instance().virtualMouseHandler().onScreenChanged();
    }

    public static KeyboardPositioner aboveOrBelowWidgetPositioner(int desiredKeyboardWidth, int desiredKeyboardHeight, int padding, Supplier<class_8030> widgetRectSupplier) {
        return (screenWidth, screenHeight) -> {
            boolean above;
            int keyboardHeight;
            class_8030 widgetRect = (class_8030)widgetRectSupplier.get();
            int keyboardWidth = Math.min(desiredKeyboardWidth, screenWidth);
            int keyboardLeft = Math.clamp((long)(widgetRect.method_48254(class_8027.field_41822) - keyboardWidth / 2), 0, screenWidth - keyboardWidth);
            int spaceBelow = screenHeight - widgetRect.method_49619() - padding;
            int spaceAbove = widgetRect.method_49618() - padding;
            if (spaceBelow >= desiredKeyboardHeight) {
                keyboardHeight = desiredKeyboardHeight;
                above = false;
            } else if (spaceAbove >= desiredKeyboardHeight) {
                keyboardHeight = desiredKeyboardHeight;
                above = true;
            } else if (spaceBelow >= spaceAbove) {
                keyboardHeight = spaceBelow;
                above = false;
            } else {
                keyboardHeight = spaceAbove;
                above = true;
            }
            int keyboardTop = above ? widgetRect.method_49618() - keyboardHeight - padding : widgetRect.method_49619() + padding;
            return new class_8030(keyboardLeft, keyboardTop, keyboardWidth, keyboardHeight);
        };
    }

    private class WrappedInputTarget
    extends InputTarget.Delegated {
        public WrappedInputTarget(InputTarget target) {
            super(target);
        }

        @Override
        public boolean acceptKeyCode(int keycode, int scancode, int modifiers) {
            if (keycode == 257 || keycode == 256) {
                KeyboardOverlayScreen.this.method_25419();
                return true;
            }
            return super.acceptKeyCode(keycode, scancode, modifiers);
        }
    }

    @FunctionalInterface
    public static interface KeyboardPositioner {
        public class_8030 positionKeyboard(int var1, int var2);
    }
}

