/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.rumble;

import com.mojang.serialization.Codec;

public record RumbleState(float strong, float weak) {
    public static final Codec<RumbleState> CODEC = Codec.INT.xmap(RumbleState::unpackFromInt, RumbleState::packToInt);
    public static final RumbleState NONE = new RumbleState(0.0f, 0.0f);

    public boolean isZero() {
        return this.strong == 0.0f && this.weak == 0.0f;
    }

    public RumbleState mul(float multiplier) {
        return new RumbleState(this.strong * multiplier, this.weak * multiplier);
    }

    public static RumbleState unpackFromInt(int packed) {
        float strong = (float)((short)(packed >> 16)) / 32767.0f;
        float weak = (float)((short)packed) / 32767.0f;
        return new RumbleState(strong, weak);
    }

    public static int packToInt(RumbleState state) {
        int high = (int)(state.strong() * 32767.0f);
        int low = (int)(state.weak() * 32767.0f);
        return high << 16 | low & 0xFFFF;
    }
}

