/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.font;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.bindings.input.Input;
import dev.isxander.controlify.controller.id.ControllerType;
import dev.isxander.controlify.platform.client.resource.SimpleControlifyReloadListener;
import dev.isxander.controlify.utils.CUtil;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7654;
import org.jetbrains.annotations.Nullable;

public class InputFontMapper
implements SimpleControlifyReloadListener<Preparations> {
    private ImmutableMap<class_2960, FontMap> mappings = ImmutableMap.of();
    private FontMap defaultFontMap;
    private static final Codec<Character> CHAR_CODEC = Codec.STRING.comapFlatMap(str -> {
        if (str.length() != 1) {
            return DataResult.error(() -> "Expected a single character string, got " + str);
        }
        return DataResult.success((Object)Character.valueOf(str.charAt(0)));
    }, String::valueOf);
    private static final Codec<Pair<Character, Map<class_2960, Character>>> FONT_MAP_CODEC = Codec.pair((Codec)CHAR_CODEC.fieldOf("unknown").codec(), (Codec)Codec.unboundedMap((Codec)class_2960.field_25139, CHAR_CODEC));
    private static final class_7654 fileToIdConverter = class_7654.method_45114((String)"controllers/font_mappings");

    @Override
    public CompletableFuture<Preparations> load(class_3300 manager, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            Map mappingResources = fileToIdConverter.method_45113(manager);
            Map<class_2960, FontMap> mappings = mappingResources.entrySet().stream().flatMap(entry -> {
                class_2960 rl = (class_2960)entry.getKey();
                class_3298 resource = (class_3298)entry.getValue();
                class_2960 namespace = fileToIdConverter.method_45115(rl);
                try (BufferedReader reader = resource.method_43039();){
                    JsonElement element = JsonParser.parseReader((Reader)reader);
                    FontMap map = FONT_MAP_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element).resultOrPartial(CUtil.LOGGER::error).map(pair -> new FontMap(namespace, ((Character)pair.getFirst()).charValue(), (Map)pair.getSecond())).orElse(null);
                    if (map == null) return Stream.empty();
                    Stream<Pair> stream = Stream.of(Pair.of((Object)namespace, (Object)map));
                    return stream;
                }
                catch (Exception e) {
                    CUtil.LOGGER.error("Failed to load font mappings for namespace {}", namespace, e);
                }
                return Stream.empty();
            }).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
            return new Preparations(mappings);
        });
    }

    @Override
    public CompletableFuture<Void> apply(Preparations data, class_3300 manager, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            data.mappings().forEach((arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
            this.mappings = builder.build();
            this.defaultFontMap = (FontMap)this.mappings.get((Object)ControllerType.DEFAULT.namespace());
        }, executor);
    }

    public FontMap getMappings(class_2960 namespace) {
        return (FontMap)this.mappings.getOrDefault((Object)namespace, (Object)this.defaultFontMap);
    }

    public class_2561 getComponentFromBinding(class_2960 namespace, @Nullable InputBinding binding) {
        if (binding == null) {
            return class_2561.method_43470((String)"?");
        }
        List<class_2960> relevantInputs = binding.boundInput().getRelevantInputs();
        return this.getComponentFromInputs(namespace, relevantInputs);
    }

    public class_2561 getComponentFromBind(class_2960 namespace, Input input) {
        List<class_2960> relevantInputs = input.getRelevantInputs();
        return this.getComponentFromInputs(namespace, relevantInputs);
    }

    public class_2561 getComponentFromInputs(class_2960 namespace, List<class_2960> inputs) {
        if (inputs.isEmpty()) {
            return class_2561.method_43470((String)"<unbound>");
        }
        FontMap fontMap = this.getMappings(namespace);
        String literal = inputs.stream().map(input -> String.valueOf(this.getChar(fontMap, (class_2960)input))).collect(Collectors.joining("+"));
        return class_2561.method_43470((String)literal).method_27694(style -> style.method_27704(CUtil.createResourceFont(fontMap.namespace().method_45138("controller/"))).method_65302(0).method_36139(-1));
    }

    private char getChar(FontMap fontMap, class_2960 input) {
        Character ch = fontMap.inputToChar().get(input);
        if (ch == null) {
            ch = this.defaultFontMap.inputToChar().getOrDefault(input, Character.valueOf(fontMap.unknown()));
        }
        return ch.charValue();
    }

    @Override
    public class_2960 getReloadId() {
        return CUtil.rl("font_mappings");
    }

    public record Preparations(Map<class_2960, FontMap> mappings) {
    }

    public record FontMap(class_2960 namespace, char unknown, Map<class_2960, Character> inputToChar) {
    }
}

