/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.bindings;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.bind.InputBindingBuilder;
import dev.isxander.controlify.bindings.BindContext;
import dev.isxander.controlify.bindings.InputBindingImpl;
import dev.isxander.controlify.bindings.defaults.DefaultBindProvider;
import dev.isxander.controlify.bindings.input.EmptyInput;
import dev.isxander.controlify.bindings.input.Input;
import dev.isxander.controlify.controller.ControllerEntity;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InputBindingBuilderImpl
implements InputBindingBuilder {
    @Nullable
    private class_2960 id;
    @Nullable
    private class_2561 category;
    @Nullable
    private class_2561 customName;
    @Nullable
    private class_2561 customDescription;
    @Nullable
    private Input defaultInput;
    private final Set<BindContext> allowedContexts = new HashSet<BindContext>();
    @Nullable
    private class_2960 radialCandidate;
    private final Set<class_304> keyCorrelations = new HashSet<class_304>();
    private class_304 keyEmulation = null;
    private Function<ControllerEntity, Boolean> keyEmulationToggle = null;
    private boolean locked;

    @Override
    public InputBindingBuilder id(@NotNull class_2960 rl) {
        this.checkLocked();
        this.id = rl;
        return this;
    }

    @Override
    public InputBindingBuilder id(@NotNull String namespace, @NotNull String path) {
        return this.id(class_2960.method_60655((String)namespace, (String)path));
    }

    @Override
    public InputBindingBuilder category(@NotNull class_2561 text) {
        this.checkLocked();
        this.category = text;
        return this;
    }

    @Override
    public InputBindingBuilder name(@NotNull class_2561 text) {
        this.checkLocked();
        this.customName = text;
        return this;
    }

    @Override
    public InputBindingBuilder description(@NotNull class_2561 text) {
        this.checkLocked();
        this.customDescription = text;
        return this;
    }

    @Override
    public InputBindingBuilder defaultInput(@Nullable Input input) {
        this.checkLocked();
        this.defaultInput = input;
        return this;
    }

    @Override
    public InputBindingBuilder allowedContexts(BindContext ... contexts) {
        this.checkLocked();
        if (contexts != null) {
            this.allowedContexts.addAll(List.of(contexts));
        }
        return this;
    }

    @Override
    public InputBindingBuilder radialCandidate(@Nullable class_2960 icon) {
        this.checkLocked();
        this.radialCandidate = icon;
        return this;
    }

    @Override
    public InputBindingBuilder addKeyCorrelation(@NotNull class_304 keyMapping) {
        this.checkLocked();
        this.keyCorrelations.add(keyMapping);
        return this;
    }

    @Override
    public InputBindingBuilder keyEmulation(@NotNull class_304 keyMapping, @Nullable Function<ControllerEntity, Boolean> toggleCondition) {
        this.checkLocked();
        this.keyEmulation = keyMapping;
        this.keyEmulationToggle = toggleCondition;
        this.addKeyCorrelation(keyMapping);
        return this;
    }

    @Override
    public InputBindingBuilder keyEmulation(@NotNull class_304 keyMapping) {
        return this.keyEmulation(keyMapping, null);
    }

    public InputBindingImpl build(ControllerEntity controller) {
        Validate.isTrue((boolean)this.locked, (String)"Tried to build builder before it was locked.", (Object[])new Object[0]);
        class_2561 name = this.createDefaultString(controller, null, false);
        if (this.customName != null) {
            name = this.customName;
        }
        class_2561 description = this.createDefaultString(controller, "desc", true);
        if (this.customDescription != null) {
            description = this.customDescription;
        }
        if (description == null) {
            description = class_2561.method_43473();
        }
        Supplier<Input> defaultSupplier = () -> {
            DefaultBindProvider provider = Controlify.instance().defaultBindManager().getDefaultBindProvider(controller.info().type().namespace());
            Input input = provider.getDefaultBind(this.id);
            if (input == null) {
                input = this.defaultInput;
            }
            if (input == null) {
                input = EmptyInput.INSTANCE;
            }
            return input;
        };
        return new InputBindingImpl(controller, this.id, name, description, this.category, defaultSupplier, this.allowedContexts, this.radialCandidate);
    }

    @NotNull
    public class_2960 getIdAndLock() {
        this.checkLocked();
        this.locked = true;
        Validate.notNull((Object)this.id, (String)"Must call `.id(Identifier)` on builder!", (Object[])new Object[0]);
        Validate.notNull((Object)this.category, (String)"Must call `.category(Component)` on builder %s!".formatted(this.id), (Object[])new Object[0]);
        return this.id;
    }

    public Set<class_304> getKeyCorrelations() {
        return this.keyCorrelations;
    }

    @Nullable
    public class_304 getKeyEmulation() {
        return this.keyEmulation;
    }

    @Nullable
    public Function<ControllerEntity, Boolean> getKeyEmulationToggle() {
        return this.keyEmulationToggle;
    }

    private void checkLocked() {
        Validate.isTrue((!this.locked ? 1 : 0) != 0, (String)"Tried to modify binding builder after is has been locked!", (Object[])new Object[0]);
    }

    private class_2561 createDefaultString(ControllerEntity controller, @Nullable String suffix, boolean notExistToNull) {
        Objects.requireNonNull(this.id);
        class_2960 type = controller.info().type().namespace();
        Object typeSpecificKey = type.method_48747("controlify.binding", this.id.method_42094());
        if (suffix != null) {
            typeSpecificKey = (String)typeSpecificKey + "." + suffix;
        }
        if (class_2477.method_10517().method_4678((String)typeSpecificKey)) {
            return class_2561.method_43471((String)typeSpecificKey);
        }
        Object genericKey = this.id.method_42093("controlify.binding");
        if (suffix != null) {
            genericKey = (String)genericKey + "." + suffix;
        }
        if (notExistToNull && !class_2477.method_10517().method_4678((String)genericKey)) {
            return null;
        }
        return class_2561.method_43471((String)genericKey);
    }
}

